<?php
// تحديد المعلومات اللازمة
$email = "mtc9afd-01@makamat.com"; // يمكنك تغييرها بالبريد الإلكتروني الخاص بك
$password = "mtc9afd-2023"; // يمكنك تغييرها بكلمة مرورك

// بناء البيانات المرسلة كجيسون
$data = json_encode(array(
    'email' => $email,
    'password' => $password
));

// بناء الطلب للحصول على رمز التميز
$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => "https://mtc9afd-01.azurewebsites.net/api/Auth/login",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => $data,
    CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "cache-control: no-cache",
        "Permissions-Policy: interest-cohort=()" // تجاهل الرأس المشكل
    ),
    CURLOPT_SSL_VERIFYHOST => false, // تعطيل التحقق من صحة الشهادة
    CURLOPT_SSL_VERIFYPEER => false, // تعطيل التحقق من الشهادة
));

// إرسال الطلب والحصول على الرد
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo "خطأ في الاتصال بالخادم: " . $err;
} else {
    // تحويل الرد إلى مصفوفة جسون
    $responseArray = json_decode($response, true);

    // استخراج الرمز المميز من الرد
    $token = $responseArray['token'];

    // عرض الرمز المميز
    echo "الرمز المميز: " . $token . "<br>";

    // بناء الطلب الجديد للحصول على بيانات RFID
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://mtc9afd-01.azurewebsites.net/api/RFIDScanData/timeperiod",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer $token",
            "cache-control: no-cache",
            "Permissions-Policy: interest-cohort=()" // تجاهل الرأس المشكل
        ),
        CURLOPT_SSL_VERIFYHOST => false, // تعطيل التحقق من صحة الشهادة
        CURLOPT_SSL_VERIFYPEER => false, // تعطيل التحقق من الشهادة
    ));

    // إرسال الطلب والحصول على الرد
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo "خطأ في الاتصال بالخادم: " . $err;
    } else {
        // التحقق من وجود بيانات RFID
        $responseData = json_decode($response, true);
        if (is_array($responseData) && count($responseData) > 0) {
            // عرض بيانات RFID
            echo "**بيانات RFID:**<br>";
            $all_epc = array();
            foreach ($responseData as $scanData) {
                if (isset($scanData['epc']) && is_array($scanData['epc'])) {
                    $all_epc = array_merge($all_epc, $scanData['epc']);
                } else {
                    $all_epc[] = $scanData['epc'];
                }
            }
        
            // طباعة جميع قيم "epc" بواسطة implode()
            echo json_encode($all_epc); // تم تعديل هنا
        
        } else {
            echo "**لا توجد بيانات RFID في الفترة المحددة.**";
        }
        
    }
}
?>
